include(opus_functions.cmake)

if(NOT IOS AND NOT ANDROID AND NOT CMAKE_SYSTEM_PROCESSOR MATCHES "arm64|aarch64") #Do not change the behaviour for mobiles
  set(OPUS_HAVE_RTCD 1)
  set(CPU_INFO_BY_ASM 1)
  set(CPU_INFO_BY_C 1)
  add_definitions(-DOPUS_HAVE_RTCD)
  add_definitions(-DCPU_INFO_BY_ASM)
  add_definitions(-DCPU_INFO_BY_C)
  message(STATUS "OPUS_HAVE_RTCD set")
endif()

add_definitions(-DHAVE_CONFIG_H)

set_property(GLOBAL PROPERTY USE_FOLDERS ON)
set_property(GLOBAL PROPERTY C_STANDARD 99)

if(MSVC)
  add_definitions(-D_CRT_SECURE_NO_WARNINGS)
endif()

include(CheckLibraryExists)
check_library_exists(m floor "" HAVE_LIBM)
if(HAVE_LIBM)
  list(APPEND OPUS_REQUIRED_LIBRARIES m)
endif()

if(CMAKE_SYSTEM_PROCESSOR MATCHES "(i[0-9]86|x86|X86|amd64|AMD64|x86_64)")
  if(CMAKE_SIZEOF_VOID_P EQUAL 8)
    set(OPUS_CPU_X64 1)
  else()
    set(OPUS_CPU_X86 1)
  endif()
elseif(CMAKE_SYSTEM_PROCESSOR MATCHES "(armv7-a|armv7|armv7s|arm64|aarch64)")
  set(OPUS_CPU_ARM 1)
endif()

opus_supports_cpu_detection(RUNTIME_CPU_CAPABILITY_DETECTION)

if(OPUS_CPU_X86 OR OPUS_CPU_X64)
  opus_detect_sse(COMPILER_SUPPORT_SIMD)
elseif(OPUS_CPU_ARM)
  opus_detect_neon(COMPILER_SUPPORT_NEON)
  if(COMPILER_SUPPORT_NEON)
    option(OPUS_USE_NEON "Option to turn off SSE" ON)
    option(OPUS_MAY_HAVE_NEON "Does runtime check for neon support" ON)
    option(OPUS_PRESUME_NEON "Assume target CPU has NEON support" OFF)
    if(CMAKE_SYSTEM_PROCESSOR MATCHES "(aarch64|arm64)")
      set(OPUS_PRESUME_NEON ON)
      set(OPUS_MAY_HAVE_NEON OFF)
    endif()
    if(CMAKE_OSX_ARCHITECTURES MATCHES "arm*")
      if(IOS)
        message(STATUS "Presuming NEON as iOS on ${CMAKE_OSX_ARCHITECTURES} detected.")
      elseif(APPLE)
        message(STATUS "Presuming NEON as Apple on ${CMAKE_OSX_ARCHITECTURES} detected.")
      else()
        message(STATUS "Presuming NEON as ${CMAKE_OSX_ARCHITECTURES} detected.")
      endif()
      set(OPUS_PRESUME_NEON ON)
      set(OPUS_MAY_HAVE_NEON OFF)
    endif()
  endif()
endif()
