# -*- rpm-spec -*-

%define _prefix    /home/cbass/src/goa/var/linphone-sdk/build/arm_v8a/install
%define pkg_prefix 

# re-define some directories for older RPMBuild versions which don't. This messes up the doc/ dir
# taken from https://fedoraproject.org/wiki/Packaging:RPMMacros?rd=Packaging/RPMMacros
%define _datarootdir       %{_prefix}/share
%define _datadir           %{_datarootdir}
%define _docdir            %{_datadir}/doc

%define build_number 29
%if %{build_number}
%define build_number_ext -%{build_number}
%endif



Name:           mswebrtc
Version:        1.1.1
Release:        %{build_number}%{?dist}
Summary:        mediastreamer2 plugin to include features from WebRTC (iSAC codec, AECM...).

Group:          Applications/Communications
License:        GPL
URL:            http://www.linphone.org
Source0:        %{name}-%{version}%{?build_number_ext}.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-buildroot

Requires:	%{pkg_prefix}bctoolbox

%description

mediastreamer2 (linphone) plugin to include features from WebRTC (iSAC codec, AECM...)

%if 0%{?rhel} && 0%{?rhel} <= 7
%global cmake_name cmake3
%define ctest_name ctest3
%else
%global cmake_name cmake
%define ctest_name ctest
%endif

# This is for debian builds where debug_package has to be manually specified, whereas in centos it does not
%define custom_debug_package %{!?_enable_debug_packages:%debug_package}%{?_enable_debug_package:%{nil}}
%custom_debug_package

%prep
%setup -n %{name}-%{version}%{?build_number_ext}

%build
%{expand:%%%cmake_name} . -DCMAKE_BUILD_TYPE=RelWithDebInfo -DCMAKE_PREFIX_PATH:PATH=%{_prefix}  -DENABLE_64BIT=0 -DENABLE_AAUDIO=0 -DENABLE_AAUDIO_AVAILABLE=0 -DENABLE_ADVANCED_IM=0 -DENABLE_AEC=1 -DENABLE_AECM=0 -DENABLE_ALSA=0 -DENABLE_AMR=0 -DENABLE_AMRNB=0 -DENABLE_AMRNB_AVAILABLE=1 -DENABLE_AMRWB=0 -DENABLE_AMRWB_AVAILABLE=1 -DENABLE_ARM4_ASM=0 -DENABLE_ARM5E_ASM=0 -DENABLE_ARM_NEON_INTRINSICS=0 -DENABLE_ARTSC=0 -DENABLE_ASSETS=1 -DENABLE_AV1=0 -DENABLE_AV1=0 -DENABLE_AV1_AVAILABLE=0 -DENABLE_BLACKFIN_ASM=0 -DENABLE_BV16=0 -DENABLE_C14N=0 -DENABLE_CAMERA2=0 -DENABLE_CAMERA2_AVAILABLE=0 -DENABLE_CATALOG=0 -DENABLE_CODEC2=0 -DENABLE_CONSOLE_UI=1 -DENABLE_CSHARP_WRAPPER=0 -DENABLE_CXX_WRAPPER=0 -DENABLE_DAEMON=1 -DENABLE_DATE=0 -DENABLE_DB_STORAGE=0 -DENABLE_DEBUG=0 -DENABLE_DEBUGGER=0 -DENABLE_DEBUG_LOGGING=0 -DENABLE_DEBUG_LOGS=0 -DENABLE_DECAF=1 -DENABLE_DEFAULT_LOG_HANDLER=1 -DENABLE_DNS_SERVICE=0 -DENABLE_DNS_SERVICE=0 -DENABLE_DNS_SERVICE_AVAILABLE=0 -DENABLE_DOC=0 -DENABLE_DOCBOOK=0 -DENABLE_EKT_SERVER_PLUGIN=0 -DENABLE_EKT_SERVER_PLUGIN_AVAILABLE=1 -DENABLE_EMBEDDED_OPENH264=0 -DENABLE_EMBEDDED_OPENH264_AVAILABLE=0 -DENABLE_EXAMPLE_PLUGIN=0 -DENABLE_FEXCEPTIONS=0 -DENABLE_FFMPEG=0 -DENABLE_FFMPEG=0 -DENABLE_FFMPEG_AVAILABLE=0 -DENABLE_FIXED_POINT=0 -DENABLE_FIXED_POINT_DEBUG=0 -DENABLE_FLEXIAPI=0 -DENABLE_FLOAT_API=1 -DENABLE_FTP=0 -DENABLE_G726=0 -DENABLE_G729=0 -DENABLE_G729B_CNG=0 -DENABLE_G729B_CNG_AVAILABLE=1 -DENABLE_G729_AVAILABLE=1 -DENABLE_GOCLEAR=1 -DENABLE_GOCLEAR_AVAILABLE=1 -DENABLE_GPL_THIRD_PARTIES=0 -DENABLE_GSM=0 -DENABLE_H263=0 -DENABLE_H263P=0 -DENABLE_H263P_AVAILABLE=0 -DENABLE_H263_AVAILABLE=0 -DENABLE_HISTORY=0 -DENABLE_HTML=0 -DENABLE_HTTP=0 -DENABLE_HW_SANITIZER=0 -DENABLE_HW_SANITIZER_AVAILABLE=0 -DENABLE_ICONV=0 -DENABLE_ICU=0 -DENABLE_ILBC=0 -DENABLE_ISAC=0 -DENABLE_ISO8859X=0 -DENABLE_JAVADOC=0 -DENABLE_JAVA_WRAPPER=0 -DENABLE_JAZZY_DOC=0 -DENABLE_JAZZY_DOC_AVAILABLE=0 -DENABLE_JPEG=0 -DENABLE_JPEG_AVAILABLE=0 -DENABLE_JSONCPP=0 -DENABLE_LDAP=0 -DENABLE_LEGACY=0 -DENABLE_LIBYUV=0 -DENABLE_LIBYUV=0 -DENABLE_LIBYUV_AVAILABLE=0 -DENABLE_LIME=0 -DENABLE_LIME_X3DH=0 -DENABLE_LIME_X3DH=0 -DENABLE_LIME_X3DH_AVAILABLE=0 -DENABLE_MBEDTLS=1 -DENABLE_MDNS=0 -DENABLE_MEM_DEBUG=0 -DENABLE_MICROSOFT_STORE_APP=0 -DENABLE_MICROSOFT_STORE_APP_AVAILABLE=0 -DENABLE_MKV=0 -DENABLE_MODULES=0 -DENABLE_MPEG4=0 -DENABLE_MPEG4_AVAILABLE=0 -DENABLE_MSWINRTVIDEO=0 -DENABLE_MSWINRTVIDEO_AVAILABLE=0 -DENABLE_NON_FREE_FEATURES=0 -DENABLE_NSS=0 -DENABLE_NTP_TIMESTAMP=0 -DENABLE_OBOE=0 -DENABLE_OBOE_AVAILABLE=0 -DENABLE_OPENGL_PROFILING=0 -DENABLE_OPENH264=0 -DENABLE_OPENH264_AVAILABLE=0 -DENABLE_OPENSSL=0 -DENABLE_OPENSSL_EXPORT=0 -DENABLE_OPUS=1 -DENABLE_OSS=1 -DENABLE_OUTPUT=1 -DENABLE_PACKAGE_SOURCE=0 -DENABLE_PATTERN=1 -DENABLE_PCAP=0 -DENABLE_PERF=0 -DENABLE_PORTAUDIO=0 -DENABLE_PQCRYPTO=0 -DENABLE_PQCRYPTO_AVAILABLE=1 -DENABLE_PULSEAUDIO=0 -DENABLE_PUSH=1 -DENABLE_QRCODE=0 -DENABLE_QRCODE=0 -DENABLE_QRCODE_AVAILABLE=0 -DENABLE_QSA=0 -DENABLE_QT_GL=0 -DENABLE_READER=1 -DENABLE_REGEXPS=1 -DENABLE_RELATIVE_PREFIX=0 -DENABLE_RESAMPLE=1 -DENABLE_RTP_MAP_ALWAYS_IN_SDP=0 -DENABLE_RUN_DEBUG=0 -DENABLE_SANITIZER=0 -DENABLE_SAX1=1 -DENABLE_SCHEMAS=1 -DENABLE_SCHEMATRON=0 -DENABLE_SILK=0 -DENABLE_SOCI=0 -DENABLE_SOUND=1 -DENABLE_SPEEX=1 -DENABLE_SPEEX_CODEC=1 -DENABLE_SPEEX_DSP=1 -DENABLE_SQLITE=0 -DENABLE_SRTP=1 -DENABLE_SSE=0 -DENABLE_STRICT=0 -DENABLE_SWIFT_DOC=0 -DENABLE_SWIFT_WRAPPER=0 -DENABLE_SWIFT_WRAPPER_COMPILATION=0 -DENABLE_SWIFT_WRAPPER_COMPILATION_AVAILABLE=0 -DENABLE_TESTS=0 -DENABLE_TESTS_COMPONENT=0 -DENABLE_THEORA=0 -DENABLE_THREADS=0 -DENABLE_THREAD_ALLOC=0 -DENABLE_TI_C55X=0 -DENABLE_TOOLS=0 -DENABLE_TREE=1 -DENABLE_TUNNEL=0 -DENABLE_TUTORIALS=1 -DENABLE_UNIT_TESTS=0 -DENABLE_UNIT_TESTS_AVAILABLE=1 -DENABLE_V4L=0 -DENABLE_V4L=0 -DENABLE_V4L_AVAILABLE=0 -DENABLE_VAD=1 -DENABLE_VALGRIND=0 -DENABLE_VALID=1 -DENABLE_VBR=1 -DENABLE_VCARD=0 -DENABLE_VIDEO=0 -DENABLE_VORBIS_PSY=0 -DENABLE_VPX=0 -DENABLE_VPX=0 -DENABLE_VPX_AVAILABLE=0 -DENABLE_WASAPI=0 -DENABLE_WASAPI_AVAILABLE=0 -DENABLE_WEBRTC_AEC=1 -DENABLE_WEBRTC_AECM=0 -DENABLE_WEBRTC_VAD=1 -DENABLE_WINDOWS_TOOLS_CHECK=0 -DENABLE_WINDOWS_TOOLS_CHECK_AVAILABLE=0 -DENABLE_WRITER=1 -DENABLE_XINCLUDE=0 -DENABLE_XML2=1 -DENABLE_XPATH=1 -DENABLE_XPTR=0 -DENABLE_ZIDCACHE=1 -DENABLE_ZRTP=1 -DENABLE_ZRTP_AVAILABLE=1
make %{?_smp_mflags}

%install
make install DESTDIR=%{buildroot}

# Dirty workaround to give exec rights for all shared libraries. Debian packaging needs this
# TODO : set CMAKE_INSTALL_SO_NO_EXE for a cleaner workaround
chmod +x `find %{buildroot} *.so.*`


%check
%{ctest_name} -V %{?_smp_mflags}

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig


%files
%defattr(-,root,root)
%doc AUTHORS ChangeLog COPYING NEWS README
%{_libdir}/mediastreamer/plugins/*.so

%changelog

* Tue Nov 27 2018 ronan.abhamon <ronan.abhamon@belledonne-communications.com>
- Do not set CMAKE_INSTALL_LIBDIR and never with _libdir!
