PKG_DIR := $(call select_from_ports,tcl)/src/noux-pkg/tcl

MAKE_TARGET := tclsh

#
# Override default install rules. We just want to keep the 'tclsh' binary.
#/
INSTALL_TARGET :=

INSTALL_LIB_DIR := install/lib/tcl8.6

INSTALL_LIB_FILES := \
	clock.tcl dde/pkgIndex.tcl http/pkgIndex.tcl http1.0/pkgIndex.tcl init.tcl \
	msgcat/msgcat.tcl msgcat/pkgIndex.tcl opt/pkgIndex.tcl package.tcl \
	platform/pkgIndex.tcl reg/pkgIndex.tcl tcltest/pkgIndex.tcl tm.tcl \
	tzdata/Etc/UTC tzdata/UTC tclIndex

installed.tag:
	@$(MSG_INST)$(TARGET)
	$(VERBOSE)mkdir -p install/bin $(INSTALL_LIB_DIR)
	$(VERBOSE)$(STRIP) tclsh -o install/bin/tclsh
	$(VERBOSE)tar -C $(PKG_DIR)/library -cf - $(INSTALL_LIB_FILES) | tar -C $(INSTALL_LIB_DIR) -xf -
	@touch $@

include $(call select_from_repositories,mk/noux.mk)

LDFLAGS += -L$(PWD)

CONFIGURE_ARGS += --disable-shared --disable-threads --disable-rpath \
                  --srcdir $(PKG_DIR)/unix

CONFIGURE_SCRIPT = $(PKG_DIR)/unix/configure

#
# By default, tclsh is generated with a hidden 'main' symbol, which cannot
# be found by Genode's dynamic linker. Since this behavior is not configurable,
# we need to patch the Makefile generated by the configure script.
#
tweak_makefile.tag: Makefile
tweak_makefile.tag:
	$(VERBOSE)echo "AC_FLAGS += -UMODULE_SCOPE" >> Makefile
	@touch $@
built.tag: tweak_makefile.tag


Makefile: dummy_libs

.SECONDARY: dummy_libs
dummy_libs: libdl.a

libdl.a:
	$(VERBOSE)$(AR) -rc $@

